/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class FluidTransformRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final List<FluidTransformRecipe> recipeList = new ArrayList<FluidTransformRecipe>();
    @Nonnull
    private final Map<FluidStack, Map<ItemLike, Fluid>> fluidResultCache = new HashMap<FluidStack, Map<ItemLike, Fluid>>();

    public boolean isValidRecipe(@Nonnull Fluid fluidInTank, @Nonnull ItemLike catalyst) {
        return this.getResult(fluidInTank, catalyst) != Fluids.f_76191_;
    }

    @Nonnull
    public Fluid getResult(@Nonnull Fluid fluidInTank, @Nonnull ItemLike catalyst) {
        FluidStack fluidStack = new FluidStack(fluidInTank, 1000);
        return this.fluidResultCache.computeIfAbsent(fluidStack, k -> new HashMap()).computeIfAbsent(catalyst.m_5456_(), k -> {
            ItemStack itemStack = new ItemStack(catalyst);
            return this.recipeList.stream().filter(fluidTransformRecipe -> fluidTransformRecipe.getFluidInTank().isFluidEqual(fluidStack)).filter(fluidTransformRecipe -> fluidTransformRecipe.getCatalyst().test(itemStack)).findFirst().map(FluidTransformRecipe::getResult).map(FluidStack::getFluid).orElse(Fluids.f_76191_);
        });
    }

    @Nonnull
    public List<FluidTransformRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<FluidTransformRecipe> recipes) {
        logger.debug("Fluid Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.fluidResultCache.clear();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.fluidResultCache.clear();
    }
}

